import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class AwsSection extends StatefulWidget {
  const AwsSection({Key? key}) : super(key: key);

  @override
  _AwsSectionState createState() => _AwsSectionState();
}

class _AwsSectionState extends State<AwsSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'Amazon Web Services S3 - Bucket Configuration',
      description: 'Below you can configure a S3 bucket which can be used for storing uploaded media.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_AWS_S3_BUCKET,
          settingKey: AppSettings.KEY_SS_TEXT_AWS_S3_BUCKET,
          type: FieldType.text,
          leading: 'Bucket Name',
          description: 'Name of S3 Bucket.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_AWS_S3_REGION,
          settingKey: AppSettings.KEY_SS_TEXT_AWS_S3_REGION,
          type: FieldType.text,
          leading: 'Bucket Region',
          description: 'Buckets are region specific and you can find the region when you are creating a bucket.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_AWS_S3_KEY,
          settingKey: AppSettings.KEY_SS_TEXT_AWS_S3_KEY,
          type: FieldType.text,
          leading: 'Credentials - Client Key',
          description: 'Part of your AWS credentials, will be used to sign programmatic requests to AWS.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_AWS_S3_SECRET,
          settingKey: AppSettings.KEY_SS_TEXT_AWS_S3_SECRET,
          type: FieldType.text,
          leading: 'Credentials - Client Secret',
          description: 'Part of your AWS credentials.',
        ),
      ],
    );
  }
}
